/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.table;

import impl.org.controlsfx.table.DistinctMappingList;
import impl.org.controlsfx.table.FilterPanel;
import impl.org.controlsfx.table.MappedList;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TableColumn;
import org.controlsfx.control.table.TableFilter;

public final class ColumnFilter<T> {
    private final TableFilter<T> tableFilter;
    private final TableColumn<T, ?> tableColumn;
    private final DistinctMappingList<T, FilterValue> filterValues;
    private final MappedList<FilterValue, T> scopedValues;
    private volatile boolean lastFilter = false;

    public ColumnFilter(TableFilter<T> tableFilter, TableColumn<T, ?> tableColumn) {
        this.tableFilter = tableFilter;
        this.tableColumn = tableColumn;
        this.filterValues = new DistinctMappingList<Object, FilterValue>(tableFilter.getBackingList(), v -> new FilterValue(tableColumn.getCellObservableValue(v), this));
        this.scopedValues = new MappedList<FilterValue, Object>(tableFilter.getTableView().getItems(), v -> new FilterValue(tableColumn.getCellObservableValue(v), this));
        this.attachContextMenu();
    }

    public void applyFilter() {
        this.tableFilter.executeFilter();
        this.lastFilter = true;
        this.tableFilter.getColumnFilters().stream().filter(c -> !c.equals(this)).forEach(c -> {
            c.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(fv -> ((FilterValue)fv).refreshScope());
    }

    public void resetFilter() {
        this.getFilterValues().forEach(v -> v.getSelectedProperty().setValue(Boolean.valueOf(true)));
        this.tableFilter.executeFilter();
        this.tableFilter.getColumnFilters().stream().forEach(c -> {
            c.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(fv -> ((FilterValue)fv).refreshScope());
    }

    public void resetAllFilters() {
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(fv -> ((FilterValue)fv).isSelected.set(true));
        this.tableFilter.executeFilter();
        this.tableFilter.getColumnFilters().stream().forEach(c -> {
            c.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(fv -> ((FilterValue)fv).refreshScope());
    }

    public ObservableList<FilterValue> getFilterValues() {
        return this.filterValues;
    }

    public TableColumn<T, ?> getTableColumn() {
        return this.tableColumn;
    }

    public TableFilter<T> getTableFilter() {
        return this.tableFilter;
    }

    public Optional<FilterValue> getFilterValue(ObservableValue<?> value) {
        return this.filterValues.stream().filter(fv -> Optional.ofNullable(((FilterValue)fv).value).map(v -> v.getValue()).equals(Optional.ofNullable(value).map(v -> v.getValue()))).findAny();
    }

    private void attachContextMenu() {
        CustomMenuItem item = FilterPanel.getInMenuItem(this);
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().add((Object)item);
        this.tableColumn.setContextMenu(contextMenu);
    }

    public static final class FilterValue {
        private final ObservableValue<?> value;
        private final BooleanProperty isSelected = new SimpleBooleanProperty(true);
        private final BooleanProperty inScope = new SimpleBooleanProperty(true);
        private final ColumnFilter<?> columnFilter;

        private FilterValue(ObservableValue<?> value, ColumnFilter<?> columnFilter) {
            this.value = value;
            this.columnFilter = columnFilter;
            this.isSelected.addListener(c -> System.out.println("FilterValue " + value + " set to " + this.isSelected.getValue()));
        }

        public ObservableValue<?> getValueProperty() {
            return this.value;
        }

        public BooleanProperty getSelectedProperty() {
            return this.isSelected;
        }

        public BooleanProperty getInScopeProperty() {
            return this.inScope;
        }

        private void refreshScope() {
            this.inScope.setValue(Boolean.valueOf(((ColumnFilter)this.columnFilter).lastFilter || ((ColumnFilter)this.columnFilter).scopedValues.contains(this)));
        }

        public String toString() {
            return this.value.getValue().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterValue that = (FilterValue)o;
            return Optional.ofNullable(this.value).map(ObservableValue::getValue).equals(Optional.ofNullable(that.value).map(ObservableValue::getValue)) || this.value.getValue().equals(that.value.getValue());
        }

        public int hashCode() {
            return this.value == null || this.value.getValue() == null ? 0 : this.value.getValue().hashCode();
        }
    }
}

