/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javafx.event.ActionEvent;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.action.AnnotatedAction;
import org.controlsfx.control.action.AnnotatedActionFactory;
import org.controlsfx.control.action.DefaultActionFactory;

public class ActionMap {
    private static AnnotatedActionFactory actionFactory = new DefaultActionFactory();
    private static final Map<String, AnnotatedAction> actions = new HashMap<String, AnnotatedAction>();

    private ActionMap() {
    }

    public static AnnotatedActionFactory getActionFactory() {
        return actionFactory;
    }

    public static void setActionFactory(AnnotatedActionFactory factory) {
        Objects.requireNonNull(factory);
        actionFactory = factory;
    }

    public static void register(Object target) {
        for (Method method : target.getClass().getDeclaredMethods()) {
            Annotation[] annotations = method.getAnnotationsByType(ActionProxy.class);
            if (annotations.length == 0) continue;
            int paramCount = method.getParameterCount();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramCount > 2) {
                throw new IllegalArgumentException(String.format("Method %s has too many parameters", method.getName()));
            }
            if (paramCount == 1 && !ActionEvent.class.isAssignableFrom(paramTypes[0])) {
                throw new IllegalArgumentException(String.format("Method %s -- single parameter must be of type ActionEvent", method.getName()));
            }
            if (!(paramCount != 2 || ActionEvent.class.isAssignableFrom(paramTypes[0]) && Action.class.isAssignableFrom(paramTypes[1]))) {
                throw new IllegalArgumentException(String.format("Method %s -- parameters must be of types (ActionEvent, Action)", method.getName()));
            }
            ActionProxy annotation = (ActionProxy)annotations[0];
            AnnotatedActionFactory factory = ActionMap.determineActionFactory(annotation);
            AnnotatedAction action = factory.createAction(annotation, method, target);
            String id = annotation.id().isEmpty() ? method.getName() : annotation.id();
            actions.put(id, action);
        }
    }

    private static AnnotatedActionFactory determineActionFactory(ActionProxy annotation) {
        AnnotatedActionFactory factory = actionFactory;
        String factoryClassName = annotation.factory();
        if (!factoryClassName.isEmpty()) {
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                factory = (AnnotatedActionFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(String.format("Action proxy refers to non-existant factory class %s", factoryClassName), ex);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalStateException(String.format("Unable to instantiate action factory class %s", factoryClassName), ex);
            }
        }
        return factory;
    }

    public static void unregister(Object target) {
        if (target != null) {
            Iterator<Map.Entry<String, AnnotatedAction>> entryIter = actions.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry<String, AnnotatedAction> entry = entryIter.next();
                Object actionTarget = entry.getValue().getTarget();
                if (actionTarget != null && actionTarget != target) continue;
                entryIter.remove();
            }
        }
    }

    public static Action action(String id) {
        return actions.get(id);
    }

    public static Collection<Action> actions(String ... ids) {
        ArrayList<Action> result = new ArrayList<Action>();
        for (String id : ids) {
            Action action;
            if (id.startsWith("---")) {
                result.add(ActionUtils.ACTION_SEPARATOR);
            }
            if ((action = ActionMap.action(id)) == null) continue;
            result.add(action);
        }
        return result;
    }
}

