/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import impl.org.controlsfx.table.ColumnFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public final class TableFilter<T> {
    private final TableView<T> tableView;
    private final ObservableList<T> backingList;
    private final FilteredList<T> filteredList;
    private final SortedList<T> sortedControlList;
    private final ObservableList<ColumnFilter<T>> columnFilters = FXCollections.observableArrayList();

    public TableFilter(TableView<T> tableView) {
        this.tableView = tableView;
        this.backingList = tableView.getItems();
        this.filteredList = new FilteredList((ObservableList)new SortedList(this.backingList));
        this.sortedControlList = new SortedList(this.filteredList);
        this.filteredList.setPredicate(v -> true);
        this.sortedControlList.comparatorProperty().bind((ObservableValue)tableView.comparatorProperty());
        tableView.setItems(this.sortedControlList);
        this.applyForAllColumns();
    }

    public ObservableList<T> getBackingList() {
        return this.backingList;
    }

    public FilteredList<T> getFilteredList() {
        return this.filteredList;
    }

    private void applyForAllColumns() {
        this.columnFilters.setAll((Collection)this.tableView.getColumns().stream().map(c -> new ColumnFilter(this, c)).collect(Collectors.toList()));
    }

    public void executeFilter() {
        this.filteredList.setPredicate(r -> !this.columnFilters.parallelStream().filter(cf -> cf.getFilterValue(cf.getTableColumn().getCellObservableValue(r)).map(ov -> ov.getSelectedProperty().getValue() == false).orElse(false)).findAny().isPresent());
    }

    public TableView<T> getTableView() {
        return this.tableView;
    }

    public ObservableList<ColumnFilter<T>> getColumnFilters() {
        return this.columnFilters;
    }

    public Optional<ColumnFilter<T>> getColumnFilter(TableColumn<T, ?> tableColumn) {
        return this.columnFilters.stream().filter(f -> f.getTableColumn().equals(tableColumn)).findAny();
    }
}

