/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.util;

import acmi.l2.clientmod.util.IOEntity;
import acmi.l2.clientmod.util.StreamsHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.scene.paint.Color;

public class IOUtil {
    public static String readString(InputStream buffer, String ... posibleValues) throws IOException {
        String val = StreamsHelper.readString(buffer);
        if (posibleValues.length != 0 && !Stream.of(posibleValues).anyMatch(value -> value.equalsIgnoreCase(val))) {
            throw new IllegalStateException("Unexpected value: " + val);
        }
        return val;
    }

    public static int readCompactInt(InputStream buffer) throws IOException {
        return StreamsHelper.readCompactInt(buffer);
    }

    public static int readInt(InputStream buffer, int ... posibleValues) throws IOException {
        int val = Integer.reverseBytes(new DataInputStream(buffer).readInt());
        if (posibleValues.length != 0 && !IntStream.of(posibleValues).anyMatch(value -> value == val)) {
            throw new IllegalStateException("Unexpected value: " + val);
        }
        return val;
    }

    public static Color readColor(InputStream buffer) throws IOException {
        DataInputStream dis = new DataInputStream(buffer);
        int b = dis.readUnsignedByte();
        int g = dis.readUnsignedByte();
        int r = dis.readUnsignedByte();
        int a = dis.readUnsignedByte();
        return Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
    }

    public static boolean readBoolean(InputStream buffer) throws IOException {
        return IOUtil.readInt(buffer, new int[0]) != 0;
    }

    public static float readFloat(InputStream buffer) throws IOException {
        return Float.intBitsToFloat(Integer.reverseBytes(new DataInputStream(buffer).readInt()));
    }

    public static IOEntity readObject(InputStream buffer, String pckg, ClassLoader classLoader) throws IOException, ReflectiveOperationException {
        String objClass = IOUtil.readString(buffer, new String[0]);
        Class<IOEntity> clazz = Class.forName(pckg + "." + objClass, true, classLoader).asSubclass(IOEntity.class);
        IOEntity obj = clazz.newInstance();
        obj.read(buffer);
        return obj;
    }

    public static void writeString(OutputStream buffer, String val) throws IOException {
        StreamsHelper.writeString(buffer, val);
    }

    public static void writeCompactInt(OutputStream buffer, int val) throws IOException {
        StreamsHelper.writeCompactInt(buffer, val);
    }

    public static void writeInt(OutputStream buffer, int val) throws IOException {
        new DataOutputStream(buffer).writeInt(Integer.reverseBytes(val));
    }

    public static void writeColor(OutputStream buffer, Color color) throws IOException {
        DataOutputStream dos = new DataOutputStream(buffer);
        dos.writeByte((int)(color.getBlue() * 255.0));
        dos.writeByte((int)(color.getGreen() * 255.0));
        dos.writeByte((int)(color.getRed() * 255.0));
        dos.writeByte((int)(color.getOpacity() * 255.0));
    }

    public static void writeBoolean(OutputStream buffer, boolean val) throws IOException {
        new DataOutputStream(buffer).writeInt(Integer.reverseBytes(val ? 1 : 0));
    }

    public static void writeFloat(OutputStream buffer, float val) throws IOException {
        new DataOutputStream(buffer).writeInt(Integer.reverseBytes(Float.floatToIntBits(val)));
    }

    public static void writeObject(OutputStream buffer, IOEntity val) throws IOException {
        IOUtil.writeString(buffer, val.getClass().getSimpleName());
        val.write(buffer);
    }
}

