/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.util;

import acmi.l2.clientmod.util.IOEntity;
import acmi.l2.clientmod.util.Named;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import javafx.util.Pair;

public class ScriptMethods {
    public static Named getAt(List<? extends Named> list, String name) {
        return list.parallelStream().filter(e -> e.getName().equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException(name + " not found"));
    }

    public static String constructorString(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            int r = (int)Math.round(color.getRed() * 255.0);
            int g = (int)Math.round(color.getGreen() * 255.0);
            int b = (int)Math.round(color.getBlue() * 255.0);
            int o = (int)Math.round(color.getOpacity() * 255.0);
            return String.format("Color.web(\"0x%02x%02x%02x%02x\")", r, g, b, o);
        }
        if (object instanceof Enum) {
            Enum enumObject = (Enum)object;
            return String.format("%s.%s", ScriptMethods.getClassName(enumObject.getDeclaringClass()), enumObject.name());
        }
        if (object instanceof CharSequence) {
            return String.format("\"%s\"", object);
        }
        return String.valueOf(object);
    }

    public static String getClassName(Class clazz) {
        String className = clazz.getName();
        return className.substring(className.indexOf(46) + 1).replaceAll("\\$", ".");
    }

    public static String toPropertyString(Object obj) {
        return ScriptMethods.toPropertyString(obj, false, true, false);
    }

    public static String toPropertyString(Object obj, boolean includeNames) {
        return ScriptMethods.toPropertyString(obj, includeNames, true, false);
    }

    public static String toPropertyString(Object obj, boolean includeNames, boolean includeParent) {
        return ScriptMethods.toPropertyString(obj, includeNames, includeParent, false);
    }

    public static String toPropertyString(Object obj, boolean includeNames, boolean includeParent, boolean listContent) {
        Class c;
        ArrayList<Pair> properties = new ArrayList<Pair>();
        LinkedList list = new LinkedList();
        if (includeParent) {
            for (c = obj.getClass(); c != Object.class; c = c.getSuperclass()) {
                list.add(c);
            }
        } else {
            list.add(c);
        }
        while ((c = (Class)list.pollLast()) != null) {
            for (Field f : c.getDeclaredFields()) {
                if (f.isSynthetic()) continue;
                f.setAccessible(true);
                try {
                    Object o = f.get(obj);
                    String s = o instanceof List ? (listContent ? "[" + ((List)o).stream().map(i -> i instanceof IOEntity ? ScriptMethods.toPropertyString(i, includeNames, includeParent, listContent) : Objects.toString(i)).collect(Collectors.joining("\t")) + "]" : "[..]") : Objects.toString(o);
                    properties.add(new Pair((Object)f.getName(), (Object)s));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return '[' + properties.stream().map(p -> includeNames ? (String)p.getKey() + "=" + (String)p.getValue() : (String)p.getValue()).collect(Collectors.joining("\t")) + ']';
    }
}

