/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class StreamsHelper {
    private static Charset defaultCharset = Charset.forName("ascii");
    private static CharsetEncoder defaultEncoder = defaultCharset.newEncoder();
    private static Charset utf16leCharset = Charset.forName("utf-16le");

    public static int readCompactInt(InputStream input) throws IOException {
        int output = 0;
        boolean signed = false;
        for (int i = 0; i < 5; ++i) {
            int x = input.read();
            if (x < 0) {
                throw new EOFException();
            }
            if (i == 0) {
                if ((x & 0x80) > 0) {
                    signed = true;
                }
                output |= x & 0x3F;
                if ((x & 0x40) != 0) continue;
                break;
            }
            if (i == 4) {
                output |= (x & 0x1F) << 27;
                continue;
            }
            output |= (x & 0x7F) << 6 + (i - 1) * 7;
            if ((x & 0x80) == 0) break;
        }
        if (signed) {
            output *= -1;
        }
        return output;
    }

    public static String readString(InputStream input) throws IOException {
        int len = StreamsHelper.readCompactInt(input);
        if (len == 0) {
            return "";
        }
        byte[] bytes = new byte[len > 0 ? len : -2 * len];
        new DataInputStream(input).readFully(bytes);
        return new String(bytes, 0, bytes.length - (len > 0 ? 1 : 2), len > 0 ? defaultCharset : utf16leCharset).intern();
    }

    public static void writeCompactInt(OutputStream output, int value) throws IOException {
        output.write(StreamsHelper.compactIntToByteArray(value));
    }

    public static void writeString(OutputStream buffer, String s) throws IOException {
        if (s == null || s.isEmpty()) {
            StreamsHelper.writeCompactInt(buffer, 0);
            return;
        }
        boolean def = defaultEncoder.canEncode(s = s + '\u0000');
        byte[] bytes = s.getBytes(def ? defaultCharset : utf16leCharset);
        StreamsHelper.writeCompactInt(buffer, def ? bytes.length : -bytes.length / 2);
        buffer.write(bytes);
    }

    public static byte[] compactIntToByteArray(int v) {
        boolean negative = v < 0;
        v = Math.abs(v);
        int[] bytes = new int[]{v & 0x3F, v >> 6 & 0x7F, v >> 13 & 0x7F, v >> 20 & 0x7F, v >> 27 & 0x7F};
        if (negative) {
            bytes[0] = bytes[0] | 0x80;
        }
        int size = 5;
        for (int i = 4; i > 0 && bytes[i] == 0; --i) {
            --size;
        }
        byte[] res = new byte[size];
        for (int i = 0; i < size; ++i) {
            if (i != size - 1) {
                int n = i;
                bytes[n] = bytes[n] | (i == 0 ? 64 : 128);
            }
            res[i] = (byte)bytes[i];
        }
        return res;
    }
}

