/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.util;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public class SubclassManager {
    private static SubclassManager instance;
    private Map<Class, Collection<Class>> subclassMap = new HashMap<Class, Collection<Class>>();

    public static SubclassManager getInstance() {
        if (instance == null) {
            instance = new SubclassManager();
        }
        return instance;
    }

    private SubclassManager() {
    }

    public void registerClass(Class clazz) {
        while (clazz != Object.class) {
            Class parent = clazz.getSuperclass();
            if (!this.subclassMap.containsKey(parent)) {
                this.subclassMap.put(parent, new HashSet());
            }
            this.subclassMap.get(parent).add(clazz);
            clazz = parent;
        }
    }

    public Collection<Class> getClassWithAllSubclasses(Class clazz) {
        TreeSet<Class> subclasses = new TreeSet<Class>((o1, o2) -> o1.getSimpleName().compareTo(o2.getSimpleName()));
        this.fillList(clazz, subclasses);
        return subclasses;
    }

    private void fillList(Class clazz, Collection<Class> subclasses) {
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            subclasses.add(clazz);
        }
        if (this.subclassMap.containsKey(clazz)) {
            this.subclassMap.get(clazz).forEach(s -> this.fillList((Class)s, subclasses));
        }
    }
}

