/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.xdat;

import acmi.l2.clientmod.util.Description;
import acmi.l2.clientmod.util.IOEntity;
import acmi.l2.clientmod.util.SubclassManager;
import acmi.l2.clientmod.util.Type;
import acmi.l2.clientmod.xdat.Dialogs;
import acmi.l2.clientmod.xdat.PropertySheetSkin;
import acmi.l2.clientmod.xdat.ReflectionProperty;
import acmi.l2.clientmod.xdat.XdatEditor;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.controlsfx.control.HyperlinkLabel;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.dialog.ExceptionDialog;

public class Controller
implements Initializable {
    private static final Logger log = Logger.getLogger(Controller.class.getName());
    private XdatEditor editor;
    @FXML
    private MenuItem open;
    @FXML
    private MenuItem save;
    @FXML
    private MenuItem saveAs;
    @FXML
    private Menu versionMenu;
    private ToggleGroup version = new ToggleGroup();
    @FXML
    private TabPane tabs;
    @FXML
    private ProgressBar progressBar;
    private File initialDirectory = new File(System.getProperty("user.dir"), "");
    private File xdatFile;
    private List<ChangeListener<IOEntity>> xdatListeners = new ArrayList<ChangeListener<IOEntity>>();

    public Controller(XdatEditor editor) {
        this.editor = editor;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Node scriptingTab = this.loadScriptTabContent();
        this.editor.xdatClassProperty().addListener((ob, ov, nv) -> {
            log.log(Level.INFO, String.format("XDAT class selected: %s", nv.getName()));
            this.tabs.getTabs().clear();
            Iterator<ChangeListener<IOEntity>> it = this.xdatListeners.iterator();
            while (it.hasNext()) {
                this.editor.xdatObjectProperty().removeListener(it.next());
                it.remove();
            }
            this.editor.setXdatObject(null);
            if (scriptingTab != null) {
                Tab tab = new Tab("script console");
                tab.setContent(scriptingTab);
                this.tabs.getTabs().add((Object)tab);
            }
            Arrays.stream(nv.getDeclaredFields()).filter(field -> List.class.isAssignableFrom(field.getType())).forEach(field -> {
                field.setAccessible(true);
                this.tabs.getTabs().add((Object)this.createTab((Field)field));
            });
        });
        this.progressBar.visibleProperty().bind((ObservableValue)this.editor.workingProperty());
        this.open.disableProperty().bind((ObservableValue)Bindings.isNull(this.editor.xdatClassProperty()));
        BooleanBinding nullXdatObject = Bindings.isNull(this.editor.xdatObjectProperty());
        this.tabs.disableProperty().bind((ObservableValue)nullXdatObject);
        this.save.disableProperty().bind((ObservableValue)nullXdatObject);
        this.saveAs.disableProperty().bind((ObservableValue)nullXdatObject);
    }

    public void registerVersion(String name, String xdatClass) {
        RadioMenuItem menuItem = new RadioMenuItem(name);
        menuItem.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.editor.execute(() -> {
                    Class<IOEntity> clazz = Class.forName(xdatClass, true, this.editor.getSchemaClassLoader()).asSubclass(IOEntity.class);
                    Platform.runLater(() -> this.editor.setXdatClass(clazz));
                    return null;
                }, e -> {
                    log.log(Level.WARNING, String.format("%s: XDAT class load error", name), (Throwable)e);
                    this.version.getToggles().remove((Object)menuItem);
                    this.versionMenu.getItems().remove((Object)menuItem);
                    Platform.runLater(() -> Dialogs.show(Alert.AlertType.ERROR, name + ": XDAT class load error", null, e.getClass().getSimpleName() + ": " + e.getMessage()));
                });
            }
        });
        this.version.getToggles().add((Object)menuItem);
        this.versionMenu.getItems().add((Object)menuItem);
    }

    private Node loadScriptTabContent() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("scripting/main.fxml"));
            loader.setControllerFactory(param -> new acmi.l2.clientmod.xdat.scripting.Controller(this.editor));
            return Controller.wrap((Node)loader.load());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Couldn't load script console", e);
            return null;
        }
    }

    private static AnchorPane wrap(Node node) {
        AnchorPane anchorPane = new AnchorPane(new Node[]{node});
        AnchorPane.setTopAnchor((Node)node, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)node, (Double)0.0);
        return anchorPane;
    }

    private Tab createTab(Field listField) {
        Tab tab = new Tab(listField.getName());
        SplitPane pane = new SplitPane();
        TextField filter = TextFields.createClearableTextField();
        VBox.setMargin((Node)filter, (Insets)new Insets(2.0));
        TreeView<Object> elements = this.createTreeView(listField, (ObservableValue<String>)filter.textProperty());
        VBox.setVgrow(elements, (Priority)Priority.ALWAYS);
        PropertySheet properties = this.createPropertySheet(elements);
        pane.getItems().addAll((Object[])new Node[]{new VBox(new Node[]{filter, elements}), properties});
        pane.setDividerPositions(new double[]{0.3});
        tab.setContent((Node)Controller.wrap((Node)pane));
        return tab;
    }

    private TreeView<Object> createTreeView(Field listField, ObservableValue<String> filter) {
        TreeView elements = new TreeView();
        elements.setShowRoot(false);
        elements.setContextMenu(this.createContextMenu((TreeView<Object>)elements));
        ChangeListener xdatChangeListener = (observable, oldValue, newValue) -> this.buildTree((IOEntity)newValue, listField, (TreeView<Object>)elements, (String)filter.getValue());
        this.xdatListeners.add((ChangeListener<IOEntity>)xdatChangeListener);
        this.editor.xdatObjectProperty().addListener(xdatChangeListener);
        filter.addListener(observable -> this.buildTree((IOEntity)this.editor.xdatObjectProperty().get(), listField, (TreeView<Object>)elements, (String)filter.getValue()));
        return elements;
    }

    private void buildTree(IOEntity entity, Field listField, TreeView<Object> elements, String nameFilter) {
        elements.setRoot(null);
        if (entity == null) {
            return;
        }
        try {
            List list = (List)listField.get(entity);
            if (!listField.isAnnotationPresent(Type.class)) {
                log.log(Level.WARNING, String.format("XDAT.%s: @Type not defined", listField.getName()));
                Dialogs.show(Alert.AlertType.ERROR, "ReflectiveOperationException", null, String.format("XDAT.%s: @Type not defined", listField.getName()));
            } else {
                Class<IOEntity> type = listField.getAnnotation(Type.class).value().asSubclass(IOEntity.class);
                TreeItem rootItem = new TreeItem((Object)new ListHolder(entity, list, listField.getName(), type));
                elements.setRoot(rootItem);
                list.stream().map(this::createTreeItem).filter(treeItem -> this.checkTreeNode((TreeItem<Object>)treeItem, nameFilter)).forEach(treeItem -> rootItem.getChildren().add(treeItem));
            }
        }
        catch (IllegalAccessException e) {
            log.log(Level.WARNING, String.format("%s.%s is not accessible", listField.getDeclaringClass().getSimpleName(), listField.getName()), e);
            Dialogs.show(Alert.AlertType.ERROR, "ReflectiveOperationException", null, listField.getDeclaringClass().getSimpleName() + "." + listField.getName() + " is not accessible");
        }
    }

    private boolean checkTreeNode(TreeItem<Object> treeItem, String nameFilter) {
        if (this.checkName(Objects.toString(treeItem.getValue()), nameFilter)) {
            return true;
        }
        for (TreeItem childItem : treeItem.getChildren()) {
            if (!this.checkTreeNode((TreeItem<Object>)childItem, nameFilter)) continue;
            return true;
        }
        return false;
    }

    private boolean checkName(String s, String nameFilter) {
        return s.toLowerCase().contains(nameFilter.toLowerCase());
    }

    private ContextMenu createContextMenu(TreeView<Object> elements) {
        ContextMenu contextMenu = new ContextMenu();
        elements.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            contextMenu.getItems().clear();
            if (newValue == null) {
                return;
            }
            Object value = newValue.getValue();
            if (value instanceof ListHolder) {
                contextMenu.getItems().add((Object)this.createAddMenu("Add ..", (TreeItem<Object>)newValue));
            } else {
                MenuItem add = this.createAddMenu("Add to parent ..", (TreeItem<Object>)newValue.getParent());
                MenuItem delete = new MenuItem("Delete");
                delete.setOnAction(event -> {
                    ListHolder parent = (ListHolder)newValue.getParent().getValue();
                    int index = parent.list.indexOf(value);
                    this.editor.getHistory().valueRemoved(this.treeItemToScriptString(newValue.getParent()), index);
                    parent.list.remove(index);
                    newValue.getParent().getChildren().remove(newValue);
                });
                contextMenu.getItems().addAll((Object[])new MenuItem[]{add, delete});
            }
        });
        return contextMenu;
    }

    private MenuItem createAddMenu(String name, TreeItem<Object> newValue) {
        ListHolder listHolder = (ListHolder)newValue.getValue();
        MenuItem add = new MenuItem(name);
        add.setOnAction(event -> {
            Collection<Class> classes = SubclassManager.getInstance().getClassWithAllSubclasses(listHolder.type);
            Stream<ClassHolder> st = classes.stream().map(x$0 -> new ClassHolder((Class)x$0));
            List list = st.collect(Collectors.toList());
            ChoiceDialog cd = new ChoiceDialog(list.get(0), list);
            cd.setTitle("Select class");
            cd.setHeaderText(null);
            cd.showAndWait().ifPresent(toCreate -> {
                IOEntity obj = null;
                try {
                    obj = toCreate.clazz.newInstance();
                    listHolder.list.add(obj);
                    newValue.getChildren().add(this.createTreeItem(obj));
                    this.editor.getHistory().valueCreated(this.treeItemToScriptString(newValue), toCreate.clazz);
                }
                catch (ReflectiveOperationException e) {
                    log.log(Level.WARNING, String.format("Couldn't instantiate %s", toCreate.clazz.getName()), e);
                    Dialogs.show(Alert.AlertType.ERROR, "ReflectiveOperationException", null, "Couldn't instantiate " + toCreate.clazz);
                }
            });
        });
        return add;
    }

    private TreeItem<Object> createTreeItem(IOEntity o) {
        TreeItem item = new TreeItem((Object)o);
        ArrayList listFields = new ArrayList();
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> List.class.isAssignableFrom(field.getType())).filter(field -> !field.isSynthetic()).forEach(listFields::add);
        }
        listFields.forEach(field -> {
            field.setAccessible(true);
            try {
                List list = (List)field.get(o);
                if (!field.isAnnotationPresent(Type.class)) {
                    log.log(Level.WARNING, String.format("%s.%s: @Type not defined", o.getClass().getName(), field.getName()));
                    Dialogs.show(Alert.AlertType.ERROR, "ReflectiveOperationException", null, String.format("%s.%s: @Type not defined", o.getClass().getName(), field.getName()));
                } else {
                    Class<IOEntity> type = field.getAnnotation(Type.class).value().asSubclass(IOEntity.class);
                    TreeItem listItem = new TreeItem((Object)new ListHolder(o, list, field.getName(), type));
                    item.getChildren().add((Object)listItem);
                    list.forEach(e -> listItem.getChildren().add(this.createTreeItem((IOEntity)e)));
                }
            }
            catch (IllegalAccessException e2) {
                log.log(Level.WARNING, o.getClass() + "." + field.getName() + " is not accessible", e2);
                Dialogs.show(Alert.AlertType.ERROR, "ReflectiveOperationException", null, String.format(o.getClass() + "." + field.getName() + " is not accessible", new Object[0]));
            }
        });
        return item;
    }

    private PropertySheet createPropertySheet(TreeView<Object> elements) {
        PropertySheet properties = new PropertySheet();
        properties.setSkin((Skin)new PropertySheetSkin(properties));
        elements.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            properties.getItems().clear();
            if (newValue == null) {
                return;
            }
            Object obj = newValue.getValue();
            if (obj instanceof ListHolder) {
                return;
            }
            for (Class<?> objClass = obj.getClass(); objClass != Object.class; objClass = objClass.getSuperclass()) {
                for (Field field : objClass.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    String description = "";
                    if (field.isAnnotationPresent(Description.class)) {
                        description = field.getAnnotation(Description.class).value();
                    }
                    field.setAccessible(true);
                    ReflectionProperty property = new ReflectionProperty(obj, field, objClass.getSimpleName(), description);
                    property.addListener((observable1, oldValue1, newValue1) -> this.editor.getHistory().valueChanged(this.treeItemToScriptString((TreeItem)newValue), field.getName(), newValue1));
                    properties.getItems().add((Object)property);
                }
            }
        });
        return properties;
    }

    private String treeItemToScriptString(TreeItem item) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        do {
            list.add(item);
        } while ((item = item.getParent()) != null);
        Collections.reverse(list);
        StringBuilder sb = new StringBuilder("xdat");
        for (int i = 0; i < list.size(); ++i) {
            Object value = ((TreeItem)list.get(i)).getValue();
            if (!(value instanceof ListHolder)) continue;
            ListHolder holder = (ListHolder)((TreeItem)list.get(i)).getValue();
            sb.append('.').append(holder.name);
            if (i + 1 >= list.size()) continue;
            sb.append('[').append(holder.list.indexOf(((TreeItem)list.get(++i)).getValue())).append(']');
        }
        return sb.toString();
    }

    @FXML
    private void open() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open interface.xdat");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XDAT (*.xdat)", new String[]{"*.xdat"}), new FileChooser.ExtensionFilter("All files", new String[]{"*.*"})});
        if (this.initialDirectory != null) {
            fileChooser.setInitialDirectory(this.initialDirectory);
        }
        this.xdatFile = fileChooser.showOpenDialog((Window)this.editor.getStage());
        if (this.xdatFile == null) {
            return;
        }
        this.initialDirectory = this.xdatFile.getParentFile();
        try {
            IOEntity xdat = this.editor.getXdatClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            this.editor.execute(() -> {
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.xdatFile));){
                    xdat.read(is);
                    Platform.runLater(() -> this.editor.setXdatObject(xdat));
                }
                return null;
            }, e -> {
                log.log(Level.WARNING, "Read error", (Throwable)e);
                Platform.runLater(() -> {
                    ExceptionDialog ed = new ExceptionDialog((Throwable)e);
                    ed.setTitle("Read error");
                    ed.setHeaderText(null);
                    ed.setContentText(e.getClass().getSimpleName() + ":\n" + e.getMessage().substring(0, Integer.min(e.getMessage().length(), 160)));
                    ed.show();
                });
            });
        }
        catch (ReflectiveOperationException e2) {
            log.log(Level.WARNING, "XDAT class should have empty public constructor", e2);
            Dialogs.show(Alert.AlertType.ERROR, "ReflectiveOperationException", null, "XDAT class should have empty public constructor");
        }
    }

    @FXML
    private void save() {
        if (this.xdatFile == null) {
            return;
        }
        this.editor.execute(() -> {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.xdatFile));){
                this.editor.getXdatObject().write(os);
            }
            return null;
        }, e -> {
            log.log(Level.WARNING, "Write error", (Throwable)e);
            Platform.runLater(() -> Dialogs.show(Alert.AlertType.ERROR, e.getClass().getSimpleName(), null, e.getMessage()));
        });
    }

    @FXML
    private void saveAs() {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XDAT (*.xdat)", new String[]{"*.xdat"}), new FileChooser.ExtensionFilter("All files", new String[]{"*.*"})});
        fileChooser.setInitialFileName(this.xdatFile.getName());
        if (this.initialDirectory != null) {
            fileChooser.setInitialDirectory(this.initialDirectory);
        }
        if ((file = fileChooser.showSaveDialog((Window)this.editor.getStage())) == null) {
            return;
        }
        this.xdatFile = file;
        this.initialDirectory = file.getParentFile();
        this.save();
    }

    @FXML
    private void exit() {
        Platform.exit();
    }

    @FXML
    private void donate() {
        try {
            Desktop.getDesktop().browse(new URI("https://sites.google.com/site/l2clientmod/donation"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void checkUpdate() {
        this.editor.execute(() -> {
            if (this.editor.updateAvailable(false)) {
                Platform.runLater(() -> {
                    if (Dialogs.showAndWait(Alert.AlertType.CONFIRMATION, "Update available", null, "Go to homepage?").get() == ButtonType.OK) {
                        this.editor.goToHomepage();
                    }
                });
            } else {
                Platform.runLater(() -> Dialogs.show(Alert.AlertType.INFORMATION, "Update", null, "You are using the latest version."));
            }
            return null;
        }, e -> Platform.runLater(() -> Dialogs.show(Alert.AlertType.INFORMATION, "Update failed", null, e.getClass().getSimpleName() + ": " + e.getMessage())));
    }

    @FXML
    private void about() {
        String text = "XDAT Editor\nVersion: " + this.editor.getApplicationVersion() + "\n" + "\n" + "[Homepage]";
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(text);
        hyperlinkLabel.setOnAction(event -> {
            String str;
            Hyperlink link = (Hyperlink)event.getSource();
            switch (str = link == null ? "" : link.getText()) {
                case "Homepage": {
                    this.editor.goToHomepage();
                }
            }
        });
        Dialogs.show(Alert.AlertType.INFORMATION, "About", null, (Node)hyperlinkLabel);
    }

    private static class ClassHolder {
        Class<? extends IOEntity> clazz;

        private ClassHolder(Class<? extends IOEntity> clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            return this.clazz.getSimpleName();
        }
    }

    private static class ListHolder {
        IOEntity entity;
        List<IOEntity> list;
        String name;
        Class<? extends IOEntity> type;

        ListHolder(IOEntity entity, List<IOEntity> list, String name, Class<? extends IOEntity> type) {
            this.entity = entity;
            this.list = list;
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }
    }
}

