/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.xdat;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.PropertyEditor;

public class PropertySheetSkin
extends BehaviorSkinBase<PropertySheet, BehaviorBase<PropertySheet>> {
    private static final int MIN_COLUMN_WIDTH = 100;
    private Accordion accordion = new Accordion();

    public PropertySheetSkin(PropertySheet control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.getChildren().add((Object)this.accordion);
        control.getItems().addListener(change -> this.updatePropertySheetContainer());
    }

    private void updatePropertySheetContainer() {
        this.accordion.getPanes().clear();
        TreeMap<String, ArrayList<PropertySheet.Item>> categoryMap = new TreeMap<String, ArrayList<PropertySheet.Item>>();
        for (PropertySheet.Item p : ((PropertySheet)this.getSkinnable()).getItems()) {
            String category = p.getCategory();
            ArrayList<PropertySheet.Item> list = (ArrayList<PropertySheet.Item>)categoryMap.get(category);
            if (list == null) {
                list = new ArrayList<PropertySheet.Item>();
                categoryMap.put(category, list);
            }
            list.add(p);
        }
        for (String category : categoryMap.keySet()) {
            PropertyPane props = new PropertyPane((List)categoryMap.get(category));
            if (props.getChildrenUnmodifiable().size() <= 0) continue;
            ScrollPane scrollPane = new ScrollPane((Node)props);
            scrollPane.setFitToWidth(true);
            TitledPane pane = new TitledPane(category, (Node)scrollPane);
            pane.setExpanded(true);
            this.accordion.getPanes().add((Object)pane);
        }
        if (!this.accordion.getPanes().isEmpty()) {
            this.accordion.setExpandedPane((TitledPane)this.accordion.getPanes().get(0));
        }
    }

    private class PropertyPane
    extends GridPane {
        public PropertyPane(List<PropertySheet.Item> properties) {
            this(properties, 0);
        }

        public PropertyPane(List<PropertySheet.Item> properties, int nestingLevel) {
            this.setVgap(5.0);
            this.setHgap(5.0);
            this.setPadding(new Insets(5.0, 15.0, 5.0, (double)(15 + nestingLevel * 10)));
            this.getStyleClass().add((Object)"property-pane");
            this.setItems(properties);
        }

        public void setItems(List<PropertySheet.Item> properties) {
            this.getChildren().clear();
            int row = 0;
            for (PropertySheet.Item item : properties) {
                String title = item.getName();
                Label label = new Label(title);
                label.setMinWidth(100.0);
                String description = item.getDescription();
                if (description != null && !description.trim().isEmpty()) {
                    label.setTooltip(new Tooltip(description));
                }
                this.add((Node)label, 0, row);
                Node editor = this.getEditor(item);
                if (editor instanceof Region) {
                    ((Region)editor).setMinWidth(100.0);
                    ((Region)editor).setMaxWidth(Double.MAX_VALUE);
                }
                label.setLabelFor(editor);
                this.add(editor, 1, row);
                GridPane.setHgrow((Node)editor, (Priority)Priority.ALWAYS);
                ++row;
            }
        }

        private Node getEditor(PropertySheet.Item item) {
            Object editor = (PropertyEditor)((PropertySheet)PropertySheetSkin.this.getSkinnable()).getPropertyEditorFactory().call((Object)item);
            if (editor == null) {
                editor = new AbstractPropertyEditor<Object, TextField>(item, new TextField(), true){
                    {
                        ((TextField)this.getEditor()).setEditable(false);
                        ((TextField)this.getEditor()).setDisable(true);
                    }

                    protected ObservableValue getObservableValue() {
                        return ((TextField)this.getEditor()).textProperty();
                    }

                    public void setValue(Object value) {
                        ((TextField)this.getEditor()).setText(value == null ? "" : value.toString());
                    }
                };
            }
            editor.setValue(item.getValue());
            return editor.getEditor();
        }
    }
}

