/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.xdat;

import acmi.l2.clientmod.xdat.Update;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;

public class UpdateTask
extends Task<Void> {
    private static final Logger log = Logger.getLogger(UpdateTask.class.getName());
    private File folder;
    private String updateFile;
    private Update update;

    public UpdateTask(File folder, String updateFile, Update update) {
        this.folder = Objects.requireNonNull(folder);
        this.updateFile = Objects.requireNonNull(updateFile);
        this.update = update;
    }

    protected Void call() throws Exception {
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            throw new IOException("Couldn't create schema folder: " + this.folder);
        }
        URL url = new URL("https://drive.google.com/uc?export=download&id=" + this.updateFile);
        List lines = ResourceGroovyMethods.readLines((URL)url);
        AtomicInteger counter = new AtomicInteger();
        CompletableFuture[] lineTask = new CompletableFuture[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            int n = i;
            String line = (String)lines.get(i);
            lineTask[n] = new CompletableFuture();
            this.execute(() -> {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(line, ";");
                    String path = stringTokenizer.nextToken();
                    String link = stringTokenizer.nextToken();
                    String hash = stringTokenizer.nextToken();
                    File file = new File(this.folder, path);
                    boolean download = true;
                    if (file.exists()) {
                        MessageDigest messageDigest = MessageDigest.getInstance("md5");
                        messageDigest.update(ResourceGroovyMethods.getBytes((File)file));
                        boolean hashEquals = new BigInteger(1, messageDigest.digest()).toString(16).equalsIgnoreCase(hash);
                        if (hashEquals || file.getName().equals("versions.ini") && this.update == Update.IGNORE_VERSIONS_INI) {
                            download = false;
                        } else {
                            log.info("updater: " + String.valueOf(file) + " hash");
                        }
                    } else {
                        log.info("updater: " + String.valueOf(file) + " not exists");
                    }
                    if (download) {
                        File parent = file.getParentFile();
                        if (!parent.exists() && !parent.mkdirs()) {
                            throw new IOException("Couldn't create folder: " + parent);
                        }
                        ResourceGroovyMethods.setBytes((File)file, (byte[])ResourceGroovyMethods.getBytes((URL)new URL("https://drive.google.com/uc?export=download&id=" + link)));
                    }
                    lineTask[n].complete(null);
                }
                catch (Exception e) {
                    lineTask[n].completeExceptionally(e);
                }
                finally {
                    this.updateProgress(counter.getAndIncrement(), lines.size());
                }
            });
        }
        return CompletableFuture.allOf(lineTask).get();
    }

    private void execute(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }
}

