/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.xdat;

import acmi.l2.clientmod.util.IOEntity;
import acmi.l2.clientmod.xdat.Controller;
import acmi.l2.clientmod.xdat.Dialogs;
import acmi.l2.clientmod.xdat.History;
import acmi.l2.clientmod.xdat.Update;
import acmi.l2.clientmod.xdat.UpdateTask;
import groovy.lang.GroovyClassLoader;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Worker;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.controlsfx.dialog.ProgressDialog;

public class XdatEditor
extends Application {
    private static final Logger log = Logger.getLogger(XdatEditor.class.getName());
    private Stage stage;
    private Controller controller;
    private final ObjectProperty<Class<? extends IOEntity>> xdatClass = new SimpleObjectProperty();
    private final ObjectProperty<IOEntity> xdatObject = new SimpleObjectProperty();
    private Update updateType;
    private File schemaFolder;
    private ClassLoader schemaClassLoader;
    private String schemaUpdate;
    private String applicationUpdate;
    private String applicationVersion;
    private History history = new History();
    private final ReadOnlyBooleanWrapper working = new ReadOnlyBooleanWrapper();
    private Executor executor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    });

    public Stage getStage() {
        return this.stage;
    }

    public Class<? extends IOEntity> getXdatClass() {
        return (Class)this.xdatClass.getValue();
    }

    public ObjectProperty<Class<? extends IOEntity>> xdatClassProperty() {
        return this.xdatClass;
    }

    public void setXdatClass(Class<? extends IOEntity> xdatClass) {
        this.xdatClass.setValue(xdatClass);
    }

    public IOEntity getXdatObject() {
        return (IOEntity)this.xdatObject.get();
    }

    public ObjectProperty<IOEntity> xdatObjectProperty() {
        return this.xdatObject;
    }

    public void setXdatObject(IOEntity xdatObject) {
        this.xdatObject.set((Object)xdatObject);
    }

    public ClassLoader getSchemaClassLoader() {
        return this.schemaClassLoader;
    }

    public History getHistory() {
        return this.history;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public ReadOnlyBooleanProperty workingProperty() {
        return this.working.getReadOnlyProperty();
    }

    public boolean isWorking() {
        return this.working.get();
    }

    public void start(Stage primaryStage) throws Exception {
        this.stage = primaryStage;
        this.parseParameters();
        FXMLLoader loader = new FXMLLoader(XdatEditor.class.getResource("main.fxml"));
        loader.setControllerFactory(param -> new Controller(this));
        Parent root = (Parent)loader.load();
        this.controller = (Controller)loader.getController();
        primaryStage.setTitle("XDAT Editor");
        primaryStage.setScene(new Scene(root));
        primaryStage.show();
        this.postShow();
    }

    private void parseParameters() {
        this.schemaFolder = new File(this.getParameters().getNamed().getOrDefault("schema_folder", "schema"));
        String update = this.getParameters().getNamed().getOrDefault("update", "full").toUpperCase();
        try {
            this.updateType = Update.values()[Integer.parseInt(update)];
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.updateType = Update.valueOf(update);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        log.log(Level.INFO, "updateType=" + (Object)((Object)this.updateType));
        log.log(Level.INFO, "schemaFolder=" + this.schemaFolder);
        try (JarFile jarFile = new JarFile(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());){
            Manifest manifest = jarFile.getManifest();
            this.applicationUpdate = manifest.getMainAttributes().getValue("Update-Application");
            this.schemaUpdate = manifest.getMainAttributes().getValue("Update-Schema");
        }
        catch (IOException e) {
            log.log(Level.WARNING, "update info load error", e);
        }
    }

    private void postShow() {
        if (this.updateType != Update.OFF) {
            this.readAppVersion();
            this.checkUpdate();
        }
        this.loadSchema();
    }

    private void readAppVersion() {
        try (JarFile jarFile = new JarFile(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());){
            Manifest manifest = jarFile.getManifest();
            this.applicationVersion = manifest.getMainAttributes().getValue("Version");
        }
        catch (IOException e) {
            log.log(Level.WARNING, "version info load error", e);
        }
    }

    public void checkUpdate() {
        try {
            if (this.updateAvailable(true)) {
                if (Dialogs.showAndWait(Alert.AlertType.CONFIRMATION, "Update required", null, "Go to homepage?").get() == ButtonType.OK) {
                    this.goToHomepage();
                }
                Platform.exit();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "version check failed", e);
        }
    }

    public void goToHomepage() {
        try {
            Desktop.getDesktop().browse(new URI("https://sites.google.com/site/l2clientmod/xdat_editor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean updateAvailable(boolean ignoreMinor) throws IOException {
        String remoteVer = ResourceGroovyMethods.getText((URL)new URL("https://drive.google.com/uc?export=download&id=" + this.applicationUpdate));
        log.info("local version: " + this.applicationVersion + ", remote version: " + remoteVer);
        return ignoreMinor ? !this.applicationVersion.substring(0, this.applicationVersion.lastIndexOf(46)).equals(remoteVer.substring(0, remoteVer.lastIndexOf(46))) : !this.applicationVersion.equals(remoteVer);
    }

    private void loadSchema() {
        Runnable afterUpdate = () -> Platform.runLater(this::loadVersions);
        if (this.updateType != Update.OFF) {
            this.updateSchema(afterUpdate);
        } else {
            afterUpdate.run();
        }
    }

    private void updateSchema(Runnable nextAction) {
        if (this.schemaUpdate != null) {
            UpdateTask worker = new UpdateTask(this.schemaFolder, this.schemaUpdate, this.updateType);
            ProgressDialog pd = new ProgressDialog((Worker)worker);
            pd.setTitle("Downloading schema...");
            pd.setHeaderText(null);
            pd.show();
            this.execute(() -> {
                Platform.runLater(() -> this.working.set(false));
                worker.run();
                return null;
            }, e -> {
                Throwable t = worker.getException();
                log.log(Level.WARNING, "Update failed: ", t);
                Dialogs.show(Alert.AlertType.WARNING, "Update failed: " + t.getClass().getSimpleName(), null, t.getMessage());
            }, nextAction);
        }
    }

    private void loadVersions() {
        GroovyClassLoader classLoader = new GroovyClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        classLoader.addClasspath(this.schemaFolder.getAbsolutePath());
        this.schemaClassLoader = classLoader;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.schemaFolder, "versions.ini")));){
            List l = br.lines().collect(Collectors.toList());
            for (String line : l) {
                try {
                    StringTokenizer tokenizer = new StringTokenizer(line, ";");
                    String name = tokenizer.nextToken();
                    String className = tokenizer.nextToken();
                    this.controller.registerVersion(name, className);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, line, e);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "versions.ini read error", e);
            Dialogs.show(Alert.AlertType.WARNING, e.getClass().getSimpleName(), null, e.getMessage());
        }
    }

    public void execute(Callable<Void> r, Consumer<Exception> exceptionConsumer) {
        this.execute(r, exceptionConsumer, null);
    }

    public void execute(Callable<Void> r, Consumer<Exception> exceptionConsumer, Runnable finallyCallback) {
        this.executor.execute(() -> {
            Platform.runLater(() -> this.working.set(true));
            try {
                r.call();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
            }
            finally {
                try {
                    if (finallyCallback != null) {
                        finallyCallback.run();
                    }
                }
                finally {
                    Platform.runLater(() -> this.working.set(false));
                }
            }
        });
    }

    public static void main(String[] args) {
        XdatEditor.launch((String[])args);
    }
}

