/*
 * Decompiled with CFR 0.152.
 */
package acmi.l2.clientmod.xdat.scripting;

import acmi.l2.clientmod.util.IOEntity;
import acmi.l2.clientmod.xdat.Dialogs;
import acmi.l2.clientmod.xdat.XdatEditor;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;

public class Controller
implements Initializable {
    private static final Logger log = Logger.getLogger(Controller.class.getName());
    @FXML
    private TextArea scriptText;
    @FXML
    private TextArea output;
    private XdatEditor editor;
    private String scriptTemplate;
    private File initialDirectory = new File(System.getProperty("user.dir"), "");
    private File scriptFile;

    public Controller(XdatEditor editor) {
        this.editor = editor;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadScriptTemplate();
    }

    private void loadScriptTemplate() {
        try {
            this.scriptTemplate = ResourceGroovyMethods.getText((URL)this.getClass().getResource("script.template"));
            log.info("Script template loaded");
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Couldn't load script template", e);
        }
    }

    @FXML
    private void open() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open script");
        if (this.initialDirectory != null) {
            fileChooser.setInitialDirectory(this.initialDirectory);
        }
        this.scriptFile = fileChooser.showOpenDialog((Window)this.editor.getStage());
        if (this.scriptFile == null) {
            return;
        }
        this.initialDirectory = this.scriptFile.getParentFile();
        try {
            this.scriptText.setText(ResourceGroovyMethods.getText((File)this.scriptFile));
            this.output.setText("");
            throw new IOException("text");
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Read error", e);
            Dialogs.show(Alert.AlertType.WARNING, e.getClass().getSimpleName(), null, e.getMessage());
            return;
        }
    }

    @FXML
    private void save() {
        if (this.scriptFile == null) {
            this.saveAs();
        }
        if (this.scriptFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.scriptFile);){
            writer.write(this.scriptText.getText());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Write error", e);
            Dialogs.show(Alert.AlertType.WARNING, e.getClass().getSimpleName(), null, e.getMessage());
        }
    }

    @FXML
    private void saveAs() {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save script");
        if (this.scriptFile != null) {
            fileChooser.setInitialFileName(this.scriptFile.getName());
        }
        if (this.initialDirectory != null) {
            fileChooser.setInitialDirectory(this.initialDirectory);
        }
        if ((file = fileChooser.showSaveDialog((Window)this.editor.getStage())) == null) {
            return;
        }
        this.scriptFile = file;
        this.initialDirectory = file.getParentFile();
        this.save();
    }

    @FXML
    private void execute() {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(this.editor.getSchemaClassLoader(), binding);
        IOEntity xdat = this.editor.getXdatObject();
        binding.setVariable("xdat", (Object)xdat);
        PrintStream out = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream scriptOut = new PrintStream(baos, false);
        System.setOut(scriptOut);
        this.output.setText("");
        String script = this.scriptTemplate.replace("$pckg", this.editor.getXdatClass().getPackage().getName()).replace("$text", this.scriptText.getText());
        this.editor.execute(() -> {
            shell.evaluate(script);
            return null;
        }, exception -> exception.printStackTrace(scriptOut), () -> {
            System.setOut(out);
            Platform.runLater(() -> {
                this.output.setText(baos.toString());
                this.editor.setXdatObject(null);
                this.editor.setXdatObject(xdat);
            });
        });
    }

    @FXML
    private void pasteHistory() {
        this.scriptText.setText(this.editor.getHistory().toString());
        this.output.setText("");
    }
}

